/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.component.ComponentAccess;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.FluidStackConstants;
import com.blamejared.crafttweaker.natives.component.ExpandDataComponentType;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.fluid.IFluidStack")
@Document(value="vanilla/api/fluid/IFluidStack")
public interface IFluidStack
extends CommandStringDisplayable,
class_9322,
ComponentAccess<IFluidStack> {
    @ZenCodeType.Method
    public static IFluidStack empty() {
        return FluidStackConstants.EMPTY.get();
    }

    public static <T> IFluidStack of(T convertable) {
        return Services.PLATFORM.createFluidStack(convertable);
    }

    public static IFluidStack of(class_3611 fluid, long amount) {
        return Services.PLATFORM.createFluidStack(fluid, amount, class_9326.field_49588);
    }

    public static IFluidStack of(class_3611 fluid, long amount, class_9326 components) {
        return Services.PLATFORM.createFluidStack(fluid, amount, components);
    }

    public static <T> IFluidStack of(T convertable, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(convertable) : IFluidStack.of(convertable);
    }

    public static IFluidStack of(class_3611 fluid, long amount, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(fluid, amount, class_9326.field_49588) : IFluidStack.of(fluid, amount, class_9326.field_49588);
    }

    public static IFluidStack of(class_3611 fluid, long amount, class_9326 components, boolean mutable) {
        return mutable ? IFluidStack.ofMutable(fluid, amount, components) : IFluidStack.of(fluid, amount, components);
    }

    public static <T> IFluidStack ofMutable(T convertable) {
        return Services.PLATFORM.createFluidStackMutable(convertable);
    }

    public static IFluidStack ofMutable(class_3611 fluid, long amount) {
        return Services.PLATFORM.createFluidStackMutable(fluid, amount, class_9326.field_49588);
    }

    public static IFluidStack ofMutable(class_3611 fluid, long amount, class_9326 components) {
        return Services.PLATFORM.createFluidStackMutable(fluid, amount, components);
    }

    @ZenCodeType.Getter(value="registryName")
    default public class_2960 getRegistryName() {
        return class_7923.field_41173.method_10221((Object)this.getFluid());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean matches(IFluidStack other) {
        return this.getAmount() >= other.getAmount() && this.isFluidEqual(other);
    }

    default public boolean isFluidEqual(IFluidStack other) {
        return this.getFluid() == other.getFluid() && FluidStackConstants.TAG_EQUALS.test(this, other);
    }

    @ZenCodeType.Getter(value="empty")
    public boolean isEmpty();

    @ZenCodeType.Getter(value="amount")
    public long getAmount();

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public IFluidStack setAmount(int var1);

    @ZenCodeType.Method
    default public IFluidStack asMutable() {
        if (!this.isImmutable()) {
            return this;
        }
        return IFluidStack.of(this.getInternal());
    }

    @ZenCodeType.Method
    default public IFluidStack asImmutable() {
        if (this.isImmutable()) {
            return this;
        }
        return IFluidStack.of(this.getImmutableInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    default public IFluidStack copy() {
        if (this.isImmutable()) {
            return IFluidStack.of(this.getImmutableInternal());
        }
        return IFluidStack.ofMutable(this.getImmutableInternal());
    }

    @ZenCodeType.Getter(value="fluid")
    @ZenCodeType.Caster(implicit=true)
    public class_3611 getFluid();

    @ZenCodeType.Caster(implicit=true)
    default public CTFluidIngredient asFluidIngredient() {
        return new CTFluidIngredient.FluidStackIngredient(this);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public CTFluidIngredient asList(CTFluidIngredient other) {
        ArrayList<CTFluidIngredient> elements = new ArrayList<CTFluidIngredient>();
        elements.add(this.asFluidIngredient());
        elements.add(other);
        return new CTFluidIngredient.CompoundFluidIngredient(elements);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IData asIData() {
        return (IData)this.codec().encodeStart(IDataOps.INSTANCE.withRegistryAccess(), (Object)this).getOrThrow(s -> new IllegalStateException("Error while encoding IFluidStack as IData: " + s));
    }

    public Codec<IFluidStack> codec();

    @Override
    default public String getCommandString() {
        class_3611 fluid = this.getFluid();
        StringBuilder builder = new StringBuilder().append("<fluid:").append(class_7923.field_41173.method_10221((Object)fluid)).append(">");
        class_9326.class_9484 split = this.getComponents().method_57940().method_58759();
        split.comp_2554().method_57828(Predicate.not(class_9331::method_57877)).forEach(typedDataComponent -> builder.append(".withJsonComponent(").append(ExpandDataComponentType.getCommandString(typedDataComponent.comp_2443())).append(", ").append(typedDataComponent.method_57943(IDataOps.INSTANCE.withRegistryAccess()).getOrThrow()).append(")"));
        split.comp_2555().forEach(dataComponentType -> builder.append(".without(").append(ExpandDataComponentType.getCommandString(dataComponentType)).append(")"));
        if (!this.isEmpty() && this.getAmount() != 1L) {
            builder.append(" * ").append(this.getAmount());
        }
        return builder.toString();
    }

    public class_9335 getComponents();

    @ZenCodeType.Method
    public <T> IFluidStack with(class_9331<T> var1, @ZenCodeType.Nullable T var2);

    @ZenCodeType.Method
    default public <T> IFluidStack without(class_9331<T> type) {
        return this.remove(type);
    }

    @ZenCodeType.Method
    public IFluidStack withJsonComponent(class_9331 var1, @ZenCodeType.Nullable IData var2);

    @ZenCodeType.Method
    public IFluidStack withJsonComponents(IData var1);

    @ZenCodeType.Method
    public <T> IFluidStack remove(class_9331<T> var1);

    @ZenCodeType.Method
    public <T, U> IFluidStack update(class_9331<T> var1, T var2, U var3, BiFunction<T, U, T> var4);

    @ZenCodeType.Method
    public <T> IFluidStack update(class_9331<T> var1, T var2, UnaryOperator<T> var3);

    @ZenCodeType.Method
    public IFluidStack applyComponents(class_9323 var1);

    @ZenCodeType.Method
    public IFluidStack applyComponents(class_9326 var1);

    public <T> T getInternal();

    public <T> T getImmutableInternal();

    @Override
    default public <U> IFluidStack _without(class_9331<U> componentType) {
        return this.without(componentType);
    }

    @Override
    default public <U> IFluidStack _with(class_9331<U> componentType, @Nullable U value) {
        return this.with(componentType, value);
    }

    @Override
    default public <U> U _get(class_9331<? extends U> componentType) {
        return (U)this.method_57824(componentType);
    }

    @Override
    default public <U> boolean _has(class_9331<U> componentType) {
        return this.method_57826(componentType);
    }
}

